::
:: checksum portable verification processor, by seVen.  v0.2
:: minor edits and tweaks by (or
::
:: a checksum extra
::
:: This is a simple Windows command (batch) file that can be
:: used to access checksum's verification features when running 
:: in portable mode, from a pen-drive, or whatever. Simply drop
:: it next to checksum.exe and drop stuff on it. Multiple files 
:: and folders will be processed in a queue.
::
:: See the accompanying nfo file for usage and customization 
:: information. More information about checksum, here..
::
::	http://corz.org/windows/software/checksum/
::

@ECHO OFF
: 
: Note: 
: 
: You can disable the automatic log-path launching by
: setting the following variable to false:
: 
SET loglaunch=true
: 
: If you haven't set a default log destination in the
: checksum.ini file, then the automatic log-path launching
: feature will be auto-disabled by this script even if you
: set the above variable to true.

SET relpath="%~dp0checksum.exe"
IF NOT EXIST %relpath% GOTO ERROR2
SET inipath="%~dp0checksum.ini"
IF NOT EXIST %inipath% (SET inipath="%APPDATA%\corz\checksum\checksum.ini") ELSE (GOTO PART0)
IF NOT EXIST %inipath% GOTO ERROR3

:PART0
SET logpath=undefined
FOR /F "usebackq tokens=1,2* delims== eol=#" %%W IN (%inipath%) DO IF /i %%W==log_folder (SET logpath=%%X)
IF "%logpath%"=="undefined" (SET loglaunch=false) && (GOTO PART1)
IF NOT DEFINED logpath (SET logpath=undefined) && (SET loglaunch=false) && (GOTO PART1)
IF "%logpath:~0,12%"=="@checksumdir" SET logpath=%~dp0%logpath:~13%
IF "%logpath:~0,8%"=="@userdir" SET logpath=%APPDATA%\corz\checksum\%logpath:~9%
IF NOT "%logpath:~-1,1%"=="\" SET logpath=%logpath%\

:PART1
SET fldrs=0
SET md5s=0
SET counter=0
FOR %%F IN (%*) DO IF EXIST "%%~F\*" (SET fldrs=1) && (SET /a counter+=1)
FOR %%I IN (%*) DO IF /i %%~xI==.md5 (SET md5s=1) && (SET /a counter+=1)
IF %counter%==0 GOTO ERROR1
ECHO.
ECHO.
ECHO ::::::
ECHO :::
ECHO :::
IF %counter%==1 (ECHO ::: The following item will be processed by checksum:) ELSE (ECHO ::: A total of %counter% jobs have been added to the queue:)
ECHO :::
ECHO :::
FOR %%F IN (%*) DO IF EXIST "%%~F\*" ECHO ::: %%~F\
FOR %%I IN (%*) DO IF /i %%~xI==.md5 ECHO ::: %%~I
ECHO :::
ECHO :::
ECHO ::::::
ECHO :::
ECHO ::: NOTE: 
ECHO :::
IF %md5s%==1 ECHO ::: * The MD5 file(s) listed above will be verified.
IF %md5s%==1 ECHO :::
IF %fldrs%==1 ECHO ::: * The folder(s) listed above will be recursively
IF %fldrs%==1 ECHO :::   searched for MD5 files which will then be verified.
IF %fldrs%==1 ECHO :::
IF "%logpath%"=="undefined" (ECHO ::: * You have not specified a default path to save) ELSE (ECHO ::: * Log files will be saved to the following folder:) 
IF "%logpath%"=="undefined" (ECHO :::   the logs to. This means that checksum will be) ELSE (ECHO :::    ) 
IF "%logpath%"=="undefined" (ECHO :::   storing each log  file in the top-most folder) ELSE ECHO :::   - %logpath%
IF "%logpath%"=="undefined" ECHO :::   of every scan. Refer to the checksum.ini file
IF "%logpath%"=="undefined" (ECHO :::   if you wish to change this behavior.) && (GOTO PART2)
IF /i %loglaunch%==true ECHO :::
IF /i %loglaunch%==true ECHO ::: * The log folder will be launched automatically
IF /i %loglaunch%==true ECHO :::   after the entire operation has completed. You
IF /i %loglaunch%==true ECHO :::   can disable this action by editing this batch
IF /i %loglaunch%==true ECHO :::   script with any text editor.

:PART2
ECHO :::
ECHO ::::::
ECHO.
ECHO.
SET /p strt=::: Is it OK to continue? (y/n):
IF /i %strt%==y GOTO BEGIN
GOTO END

:BEGIN
ECHO.
ECHO.
ECHO :::
ECHO :::
ECHO ::: checksum verification in progress...
ECHO :::
ECHO :::
::	if you want to add switches, disable audio alerts, or whatever..
::                                    see here ---V---
FOR %%F IN (%*) DO IF EXIST "%%~F\*" %relpath% vrnamflq "%%~F\"
FOR %%I IN (%*) DO IF /i %%~xI==.md5 %relpath% vfnlq "%%~I"
IF /i %loglaunch%==true GOTO AUTOLAUNCH
GOTO END

:ERROR1
ECHO.
ECHO ::::::: ERROR: VALID INPUTS NOT FOUND :::::::
ECHO ::                                         ::
ECHO ::                                         ::
ECHO :: You are seeing this message because you ::
ECHO :: haven't specified ANY valid inputs.     ::
ECHO ::                                         ::
ECHO :: You must have at least one valid input  ::
ECHO :: for this script to function properly.   ::
ECHO ::                                         ::
ECHO ::                                         ::
ECHO :: Valid Inputs...... Folders/MD5 Files    ::
ECHO :: Invalid Inputs.... All Other Files      ::
ECHO ::                                         ::
ECHO ::                                         ::
ECHO :::::::::::::::::::::::::::::::::::::::::::::
ECHO.
ECHO.
ECHO ::: Press any key to quit . . .
PAUSE > NUL
GOTO END

:ERROR2
ECHO.
ECHO ::::::::: CHECKSUM.EXE NOT FOUND :::::::::
ECHO ::                                      ::
ECHO :: This batch script must be located in ::
ECHO :: the same directory as checksum.exe   ::
ECHO ::                                      ::
ECHO ::::::::::::::::::::::::::::::::::::::::::
ECHO.
ECHO.
ECHO ::: Press any key to quit . . .
PAUSE > NUL
GOTO END

:ERROR3
ECHO.
ECHO ::::::::: CHECKSUM.INI NOT FOUND :::::::::
ECHO ::                                      ::
ECHO :: Unable determine the location of     ::
ECHO :: checksum.ini on your computer!       ::
ECHO ::                                      ::
ECHO :: If you are running in portable mode  ::
ECHO :: please make sure checksum.ini is in  ::
ECHO :: the same directory as checksum.exe   ::
ECHO ::                                      ::
ECHO :: Otherwise, please try re-installing  ::
ECHO :: the latest version of checksum which ::
ECHO :: is available at corz.org             ::
ECHO ::                                      ::
ECHO ::::::::::::::::::::::::::::::::::::::::::
ECHO.
ECHO.
ECHO ::: Press any key to quit . . .
PAUSE > NUL
GOTO END

:AUTOLAUNCH
IF EXIST "%logpath%" "%WINDIR%\explorer.exe" "%logpath%"
GOTO END

:END
EXIT